/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;

public class FaucetBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197873_a((double)0.6875, (double)0.3125, (double)1.0, (double)0.3125, (double)0.9375, (double)0.3125);
    protected static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.9375, (double)0.6875);
    protected static final VoxelShape SHAPE_WEST = VoxelShapes.func_197873_a((double)1.0, (double)0.3125, (double)0.3125, (double)0.3125, (double)0.9375, (double)0.6875);
    protected static final VoxelShape SHAPE_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.9375, (double)0.3125);
    protected static final VoxelShape SHAPE_NORTH_JAR = VoxelShapes.func_197873_a((double)0.6875, (double)0.0, (double)1.0, (double)0.3125, (double)0.625, (double)0.3125);
    protected static final VoxelShape SHAPE_SOUTH_JAR = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)0.625, (double)0.6875);
    protected static final VoxelShape SHAPE_WEST_JAR = VoxelShapes.func_197873_a((double)1.0, (double)0.0, (double)0.3125, (double)0.3125, (double)0.625, (double)0.6875);
    protected static final VoxelShape SHAPE_EAST_JAR = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.6875, (double)0.6875, (double)0.625, (double)0.3125);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty HAS_WATER = BlockProperties.HAS_WATER;
    public static final IntegerProperty LIGHT_LEVEL = BlockProperties.LIGHT_LEVEL_0_15;
    public static final BooleanProperty HAS_JAR = BlockProperties.HAS_JAR;
    public static final BooleanProperty EXTENDED = BlockStateProperties.field_208174_a;

    public FaucetBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HAS_JAR, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EXTENDED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)HAS_JAR)).booleanValue()) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                default: {
                    return SHAPE_NORTH_JAR;
                }
                case SOUTH: {
                    return SHAPE_SOUTH_JAR;
                }
                case EAST: {
                    return SHAPE_EAST_JAR;
                }
                case WEST: 
            }
            return SHAPE_WEST_JAR;
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean enabled = (Boolean)state.func_177229_b((Property)ENABLED);
        if (!((Boolean)state.func_177229_b((Property)HAS_JAR)).booleanValue() && hit.func_216347_e().field_72448_b % 1.0 <= 0.4375) {
            if (enabled && ((Boolean)state.func_177229_b((Property)HAS_WATER)).booleanValue()) {
                BlockRayTraceResult rayTraceResult;
                Direction dir = (Direction)state.func_177229_b((Property)FACING);
                BlockPos backPos = pos.func_177972_a(dir.func_176734_d());
                BlockState backState = worldIn.func_180495_p(backPos);
                ActionResultType blockResult = backState.func_227031_a_(worldIn, player, handIn, rayTraceResult = new BlockRayTraceResult(new Vector3d((double)backPos.func_177958_n() + 0.5, (double)backPos.func_177956_o() + 0.5, (double)backPos.func_177952_p() + 0.5), dir, backPos, false));
                if (blockResult.func_226246_a_()) {
                    return blockResult;
                }
                ActionResultType itemResult = player.func_184586_b(handIn).func_77973_b().func_195939_a(new ItemUseContext(player, handIn, rayTraceResult));
                if (itemResult.func_226246_a_()) {
                    return itemResult;
                }
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        float f = enabled ? 0.6f : 0.5f;
        worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        this.updateBlock(state, worldIn, pos, true);
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean hasWater = this.updateTileFluid(state, pos, (IWorld)worldIn);
        if (hasWater != (Boolean)state.func_177229_b((Property)HAS_WATER)) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            boolean canConnectDown = this.canConnect(facingState, worldIn, facingPos, facing.func_176734_d());
            return (BlockState)stateIn.func_206870_a((Property)HAS_JAR, (Comparable)Boolean.valueOf(canConnectDown));
        }
        if (facing == ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d()) {
            boolean hasWater = this.updateTileFluid(stateIn, currentPos, worldIn);
            return (BlockState)((BlockState)stateIn.func_206870_a((Property)EXTENDED, (Comparable)Boolean.valueOf(this.canConnect(facingState, worldIn, facingPos, facing.func_176734_d())))).func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater));
        }
        return stateIn;
    }

    public boolean updateTileFluid(BlockState state, BlockPos pos, IWorld world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FaucetBlockTile) {
            return ((FaucetBlockTile)te).updateContainedFluidVisuals(state);
        }
        return false;
    }

    private boolean canConnect(BlockState downState, IWorld world, BlockPos pos, Direction dir) {
        if (downState.func_177230_c() instanceof JarBlock) {
            return true;
        }
        if (downState.func_235714_a_(ModTags.POURING_TANK)) {
            return false;
        }
        if (downState.func_235901_b_((Property)BlockStateProperties.field_227036_ao_)) {
            return true;
        }
        return world instanceof World && FluidUtil.getFluidHandler((World)((World)world), (BlockPos)pos, (Direction)dir).isPresent();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        this.updateBlock(state, world, pos, false);
    }

    public void updateBlock(BlockState state, World world, BlockPos pos, boolean toggle) {
        boolean hasWater;
        boolean isPowered = world.func_175640_z(pos);
        if (isPowered != (Boolean)state.func_177229_b((Property)POWERED) || toggle) {
            world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(toggle ^ (Boolean)state.func_177229_b((Property)ENABLED))), 2);
        }
        if ((hasWater = this.updateTileFluid(state, pos, (IWorld)world)) != (Boolean)state.func_177229_b((Property)HAS_WATER)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
        if ((Boolean)state.func_177229_b((Property)ENABLED) ^ toggle ^ isPowered && ((Boolean)state.func_177229_b((Property)HAS_WATER)).booleanValue()) {
            this.trySolidifyConcrete(pos.func_177977_b(), world);
        }
    }

    public void trySolidifyConcrete(BlockPos pos, World world) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b instanceof ConcretePowderBlock) {
            world.func_180501_a(pos, ((ConcretePowderBlock)b).field_200294_a, 18);
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) ^ (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208180_g);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{EXTENDED, FACING, ENABLED, POWERED, HAS_WATER, HAS_JAR, WATERLOGGED, LIGHT_LEVEL});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction dir = context.func_196000_l().func_176740_k() == Direction.Axis.Y ? Direction.NORTH : context.func_196000_l();
        boolean water = world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
        boolean hasJar = this.canConnect(world.func_180495_p(pos.func_177977_b()), (IWorld)world, pos.func_177977_b(), Direction.UP);
        BlockPos backPos = pos.func_177972_a(dir.func_176734_d());
        boolean jarBehind = this.canConnect(world.func_180495_p(backPos), (IWorld)world, backPos, dir.func_176734_d());
        boolean powered = world.func_175640_z(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)dir)).func_206870_a((Property)EXTENDED, (Comparable)Boolean.valueOf(jarBehind))).func_206870_a((Property)HAS_JAR, (Comparable)Boolean.valueOf(hasJar))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        boolean flag = this.isOpen(state);
        if (((Boolean)state.func_177229_b((Property)HAS_WATER)).booleanValue() && !((Boolean)state.func_177229_b((Property)HAS_JAR)).booleanValue()) {
            double d = random.nextFloat();
            double d2 = flag ? 0.0 : 0.06;
            if (d > d2) {
                return;
            }
            float d3 = 0.125f;
            double x = (double)pos.func_177958_n() + 0.5 + (double)d3 * ((double)random.nextFloat() - 0.5);
            double y = (double)pos.func_177956_o() + 0.25;
            double z = (double)pos.func_177952_p() + 0.5 + (double)d3 * ((double)random.nextFloat() - 0.5);
            int color = this.getTileParticleColor(pos, world);
            float r = (float)ColorHelper.PackedColor.func_233007_b_((int)color) / 255.0f;
            float g = (float)ColorHelper.PackedColor.func_233008_c_((int)color) / 255.0f;
            float b = (float)ColorHelper.PackedColor.func_233009_d_((int)color) / 255.0f;
            world.func_195594_a((IParticleData)ModRegistry.DRIPPING_LIQUID.get(), x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public int getTileParticleColor(BlockPos pos, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FaucetBlockTile) {
            return ((FaucetBlockTile)te).fluidHolder.getParticleColor((IWorldReader)world, pos);
        }
        return 4340983;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FaucetBlockTile();
    }
}

